<?php

class EWRporta_Model_Lists extends XenForo_Model
{
	public function getPageList($parent = 0, &$fullPageList = array(), $depth = 0)
	{
        $pages = $this->_getDb()->fetchAll("
			SELECT page_id, page_slug, page_name, page_parent
				FROM EWRporta_pages
			WHERE page_parent = ?
			ORDER BY page_name ASC
		", $parent);

		foreach ($pages AS &$page)
		{
			$page['page_depth'] = $depth;
			$page['page_indent'] = "";
			for ($counter = 1; $counter <= $depth; $counter++)
			{
				$page['page_indent'] .= "&nbsp; &nbsp; ";
			}
			array_push($fullPageList, $page);

			$this->getPageList($page['page_id'], $fullPageList, $depth+1);
		}

		return $fullPageList;
	}

	public function getRelated($page)
	{
		$related = array();

		if ($page['page_parent'])
		{
			$topPage = $this->_getDb()->fetchRow("
				SELECT page_id, page_slug, page_name, page_parent
					FROM EWRporta_pages
				WHERE page_id = ?
			", $page['page_parent']);

			$related = $this->getRelated($topPage);
		}
		else
		{
			array_push($related, $page);
			$related = $this->getPageList($page['page_id'], $related);
		}

		return $related;
	}

	public function getIndex()
	{
		return $this->_getDb()->fetchRow("SELECT page_name FROM EWRporta_pages WHERE page_slug = 'index'");
	}

	public function getSidebar($parent = 0, &$pageList = array(), $depth = 0)
	{
		$options = XenForo_Application::get('options');

        $pages = $this->_getDb()->fetchAll("
			SELECT page_id, page_slug, page_name
				FROM EWRporta_pages
			WHERE page_parent = ?
				AND page_slug != 'index'
			ORDER BY page_name ASC
		", $parent);

		foreach ($pages AS &$page)
		{
			$page['page_depth'] = $depth;
			$page['page_indent'] = "";
			for ($counter = 1; $counter <= $depth; $counter++)
			{
				$page['page_indent'] .= "&nbsp; &nbsp; ";
			}
			array_push($pageList, $page);

			if ($depth < $options->EWRporta_sidedepth)
			{
				$this->getSidebar($page['page_id'], $pageList, $depth+1);
			}
		}

		return $pageList;
	}

	public function getCrumbs($page, &$breadCrumbs = array())
	{
		$breadCrumbs[$page['page_slug']] = array(
			 'value' => $page['page_name'],
			 'href' => XenForo_Link::buildPublicLink('full:wiki', $page), 
		);

		if ($page['page_parent'])
		{
			$topPage = $this->_getDb()->fetchRow("
				SELECT page_slug, page_name, page_parent
					FROM EWRporta_pages
				WHERE page_id = ?
			", $page['page_parent']);

			$breadCrumbs = $this->getCrumbs($topPage, $breadCrumbs);
		}

		return $breadCrumbs;
	}

	public function getTemplates()
	{
        $templates = $this->_getDb()->fetchAll("
			SELECT template_name
				FROM EWRporta_templates
			ORDER BY template_name ASC
		");

		return $templates;
	}
}